<?php
// config_builder_fetch_data.php
$baseDir = __DIR__;
$configFile = $baseDir . "/config_fetch_data.php";

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$defaults = [
  "bar" => "5m",
  "year" => (int)date("Y"),
  "month" => (int)date("n"),
  "coins" => ["BTC-USDT"],
  "okx_base_url" => "https://www.okx.com",
  "data_root_rel" => "daily_data",
  "logs_root_rel" => "data_monthly",
  "stitched_rel"  => "data_monthly/stitched",
  "sim_out_rel"   => "data_monthly/sim",
  "overwrite_existing" => false,
  "max_retries" => 5,
  "sleep_seconds_between_pages" => 0.10,
];

$current = $defaults;
if (file_exists($configFile)) {
  $loaded = include $configFile;
  if (is_array($loaded)) $current = array_merge($current, $loaded);
}

$allCoins = [
  "BTC-USDT","ETH-USDT","SOL-USDT","XRP-USDT","LINK-USDT","ADA-USDT","DOGE-USDT","BNB-USDT"
];

$msg = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $coins = $_POST["coins"] ?? [];
  if (!is_array($coins)) $coins = [];

  $bar = (string)($_POST["bar"] ?? "5m");
  if (!in_array($bar, ["1m","3m","5m","15m","30m","1H","2H","4H","1D"], true)) $bar = "5m";

  $year = (int)($_POST["year"] ?? date("Y"));
  $month = (int)($_POST["month"] ?? date("n"));
  if ($year < 2018) $year = 2018;
  if ($month < 1) $month = 1;
  if ($month > 12) $month = 12;

  $overwrite = isset($_POST["overwrite_existing"]) && $_POST["overwrite_existing"] === "1";
  $maxRetries = (int)($_POST["max_retries"] ?? 5);
  if ($maxRetries < 1) $maxRetries = 1;
  if ($maxRetries > 20) $maxRetries = 20;

  $sleep = (float)($_POST["sleep_seconds_between_pages"] ?? 0.10);
  if ($sleep < 0) $sleep = 0;
  if ($sleep > 2) $sleep = 2;

  $okxBase = trim((string)($_POST["okx_base_url"] ?? "https://www.okx.com"));
  if ($okxBase === "") $okxBase = "https://www.okx.com";

  $newCfg = [
    "base_dir" => $baseDir,
    "bar" => $bar,
    "year" => $year,
    "month" => $month,
    "coins" => array_values(array_unique(array_filter($coins))),
    "okx_base_url" => $okxBase,
    "data_root_rel" => $current["data_root_rel"],
    "logs_root_rel" => $current["logs_root_rel"],
    "stitched_rel"  => $current["stitched_rel"],
    "sim_out_rel"   => $current["sim_out_rel"],
    "overwrite_existing" => $overwrite,
    "max_retries" => $maxRetries,
    "sleep_seconds_between_pages" => $sleep,
  ];

  $export = "<?php\n/**\n * config_fetch_data.php\n * Auto-written by config_builder_fetch_data.php\n */\nreturn " . var_export($newCfg, true) . ";\n";

  $ok = file_put_contents($configFile, $export);
  if ($ok === false) {
    $msg = "❌ Failed to write config_fetch_data.php (check permissions).";
  } else {
    $msg = "✅ Saved config_fetch_data.php";
    $current = $newCfg;
  }
}

?><!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Fetch Data Config Builder</title>
  <style>
    body { margin:0; font-family: Arial, sans-serif; background:#0b0f14; color:#e6edf3; }
    .wrap { max-width: 1100px; margin: 0 auto; padding: 24px; }
    .card { background:#101826; border:1px solid #1b2a41; border-radius: 14px; padding: 18px; }
    h1 { font-size: 20px; margin: 0 0 12px; }
    .grid { display:grid; grid-template-columns: 1fr 1fr; gap: 14px; }
    .row { display:flex; gap: 12px; flex-wrap: wrap; }
    label { font-size: 12px; color:#a9b7c6; display:block; margin-bottom: 6px; }
    input, select { width:100%; padding:10px 12px; border-radius: 10px; border:1px solid #23344f; background:#0c1320; color:#e6edf3; }
    .coins { display:grid; grid-template-columns: repeat(4, minmax(0, 1fr)); gap:10px; }
    .coin { background:#0c1320; border:1px solid #23344f; border-radius: 10px; padding:10px; display:flex; gap:8px; align-items:center; }
    .coin input { width:auto; }
    .btn { background:#1f6feb; border:0; color:white; padding:10px 14px; border-radius: 10px; cursor:pointer; }
    .muted { color:#9fb0c2; font-size: 12px; }
    .msg { margin: 10px 0 0; }
    @media (max-width: 900px) { .grid { grid-template-columns: 1fr; } .coins{ grid-template-columns: repeat(2, minmax(0,1fr)); } }
  </style>
</head>
<body>
  <div class="wrap">
    <div class="card">
      <h1>Config Builder — Monthly Data Fetch</h1>
      <div class="muted">Saves to <code>config_fetch_data.php</code>. Cron will read this file.</div>

      <?php if ($msg): ?>
        <div class="msg"><?php echo h($msg); ?></div>
      <?php endif; ?>

      <form method="post" style="margin-top:14px;">
        <div class="grid">
          <div>
            <label>Year</label>
            <input type="number" name="year" value="<?php echo h($current["year"]); ?>" min="2018" max="2100">
          </div>
          <div>
            <label>Month</label>
            <select name="month">
              <?php for($m=1;$m<=12;$m++): ?>
                <option value="<?php echo $m; ?>" <?php echo ((int)$current["month"]===$m) ? "selected" : ""; ?>>
                  <?php echo $m; ?>
                </option>
              <?php endfor; ?>
            </select>
          </div>
          <div>
            <label>Bar (candles)</label>
            <select name="bar">
              <?php foreach(["5m","1m","3m","15m","30m","1H","2H","4H","1D"] as $b): ?>
                <option value="<?php echo h($b); ?>" <?php echo ($current["bar"]===$b) ? "selected" : ""; ?>>
                  <?php echo h($b); ?>
                </option>
              <?php endforeach; ?>
            </select>
          </div>
          <div>
            <label>OKX Base URL</label>
            <input name="okx_base_url" value="<?php echo h($current["okx_base_url"]); ?>">
          </div>

          <div>
            <label>Max retries</label>
            <input type="number" name="max_retries" value="<?php echo h($current["max_retries"]); ?>" min="1" max="20">
          </div>
          <div>
            <label>Sleep between pages (sec)</label>
            <input type="number" step="0.01" name="sleep_seconds_between_pages" value="<?php echo h($current["sleep_seconds_between_pages"]); ?>" min="0" max="2">
          </div>
        </div>

        <div style="margin-top:14px;">
          <label>Coins</label>
          <div class="coins">
            <?php
              $selected = array_flip($current["coins"] ?? []);
              foreach($allCoins as $c):
            ?>
              <label class="coin">
                <input type="checkbox" name="coins[]" value="<?php echo h($c); ?>" <?php echo isset($selected[$c]) ? "checked" : ""; ?>>
                <span><?php echo h($c); ?></span>
              </label>
            <?php endforeach; ?>
          </div>
        </div>

        <div style="margin-top:14px;" class="row">
          <label class="coin" style="padding:10px 12px;">
            <input type="checkbox" name="overwrite_existing" value="1" <?php echo !empty($current["overwrite_existing"]) ? "checked" : ""; ?>>
            <span>Overwrite existing month files</span>
          </label>

          <button class="btn" type="submit">Save Config</button>
        </div>

        <div class="muted" style="margin-top:10px;">
          Output path per coin: <code>daily_data/{bar}/{coin}/{YYYY-MM}.csv</code>
        </div>
      </form>
    </div>
  </div>
</body>
</html>
