#!/bin/bash
set -euo pipefail

BASE_DIR="$(cd "$(dirname "$0")" && pwd)"
CFG="${BASE_DIR}/config_fetch_data.php"

php -r '
$cfg = include "'"$CFG"'";
echo $cfg["bar"]."\n";
echo implode(",", $cfg["coins"])."\n";
' > /tmp/kappa_stitch_cfg.txt

BAR=$(sed -n '1p' /tmp/kappa_stitch_cfg.txt)
COINS=$(sed -n '2p' /tmp/kappa_stitch_cfg.txt)

IFS=',' read -ra ARR <<< "$COINS"
for COIN in "${ARR[@]}"; do
  [ -z "$COIN" ] && continue
  python3 "${BASE_DIR}/stitch_data.py" --coin "$COIN" --bar "$BAR"
done
